/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import net.minecraft.class_1792;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.util.SimpleFlowableFluid;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.smeltery.data.Byproduct;

public enum SmelteryCompat {
    TIN(TinkerFluids.moltenTin, Byproduct.COPPER),
    ALUMINUM(TinkerFluids.moltenAluminum, Byproduct.IRON),
    LEAD(TinkerFluids.moltenLead, Byproduct.SILVER, Byproduct.GOLD),
    SILVER(TinkerFluids.moltenSilver, Byproduct.LEAD, Byproduct.GOLD),
    NICKEL(TinkerFluids.moltenNickel, Byproduct.PLATINUM, Byproduct.IRON),
    ZINC(TinkerFluids.moltenZinc, Byproduct.TIN, Byproduct.COPPER),
    PLATINUM(TinkerFluids.moltenPlatinum, Byproduct.GOLD),
    TUNGSTEN(TinkerFluids.moltenTungsten, Byproduct.PLATINUM, Byproduct.GOLD),
    OSMIUM(TinkerFluids.moltenOsmium, Byproduct.IRON),
    URANIUM(TinkerFluids.moltenUranium, Byproduct.LEAD, Byproduct.COPPER),
    BRONZE(TinkerFluids.moltenBronze, new Byproduct[0]),
    BRASS(TinkerFluids.moltenBrass, new Byproduct[0]),
    ELECTRUM(TinkerFluids.moltenElectrum, new Byproduct[0]),
    INVAR(TinkerFluids.moltenInvar, new Byproduct[0]),
    CONSTANTAN(TinkerFluids.moltenConstantan, new Byproduct[0]),
    PEWTER(TinkerFluids.moltenPewter, new Byproduct[0]),
    STEEL(TinkerFluids.moltenSteel, new Byproduct[0]),
    ENDERIUM(TinkerFluids.moltenEnderium, new Byproduct[0]),
    LUMIUM(TinkerFluids.moltenLumium, new Byproduct[0]),
    SIGNALUM(TinkerFluids.moltenSignalum, new Byproduct[0]),
    REFINED_GLOWSTONE(TinkerFluids.moltenRefinedGlowstone, false),
    REFINED_OBSIDIAN(TinkerFluids.moltenRefinedObsidian, false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends SimpleFlowableFluid> fluid;
    private final boolean isOre;
    private final boolean hasDust;
    private final Byproduct[] byproducts;

    private SmelteryCompat(FluidObject<? extends SimpleFlowableFluid> fluid, boolean hasDust) {
        this.fluid = fluid;
        this.isOre = false;
        this.byproducts = new Byproduct[0];
        this.hasDust = hasDust;
    }

    private SmelteryCompat(FluidObject<? extends SimpleFlowableFluid> fluid, Byproduct ... byproducts) {
        this.fluid = fluid;
        this.isOre = byproducts.length > 0;
        this.byproducts = byproducts;
        this.hasDust = true;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public class_1792 getBucket() {
        return this.fluid.method_8389();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public boolean hasDust() {
        return this.hasDust;
    }

    public Byproduct[] getByproducts() {
        return this.byproducts;
    }
}

